/*
 * Decompiled with CFR 0.152.
 */
import bird.gui.IPAddrEditPanel;
import bird.util.Dbg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class BPMESetup
extends JFrame
implements ActionListener,
WindowListener {
    EncryptedTCPIPCommInt encTcp = null;
    private udpip gtp_ = null;
    private int port_ = 0;
    private byte cmd_ = 0;
    private byte[] cmdStr_;
    private byte[] resp_ = new byte[512];
    private IPAddrEditPanel ipSubnetMask_;
    private JButton btnFindBPME_;
    private JButton btnSetupDefault_;
    private JButton btnLaunchWebPg_;
    private JLabel lblFileNameWeb_;
    private JLabel lblCRCWeb_;
    private JLabel lblFileNameFirmware_;
    private JLabel lblCRCFirmware_;
    private JList lbAvailIPs_;
    private DefaultListModel availIPsList_;
    private WorkerThread workerTh_ = new WorkerThread(1);
    private boolean isExecuting_ = false;
    private boolean isOperationCanceled_ = false;
    private Cursor oldCursor_ = null;
    private static final Color COLOR_BG = new Color(0, 102, 255);
    private static final Color COLOR_FG = Color.black;
    private static final String TXT_UNKNOWN_FILE_NAME = "---- UNKNOWN FILE ----";

    public BPMESetup(String string) {
        super(string);
        this.workerTh_.start();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.createFilesPanel(), "North");
        this.getContentPane().add((Component)this.createNetworkPanel(), "Center");
        this.getContentPane().add((Component)Status.getInst().createGUI(), "South");
        Status.getInst().addKeyListener(new StatusKeyAdapter());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.btnLaunchWebPg_.getActionCommand().equals(string)) {
            this.handle_launchWebPage();
        } else if (this.btnSetupDefault_.getActionCommand().equals(string)) {
            this.handle_setDefaultSettings();
        } else if (this.btnFindBPME_.getActionCommand().equals(string)) {
            this.handle_findBPME();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        boolean bl = true;
        if (this.isExecuting_) {
            try {
                int n = JOptionPane.showConfirmDialog(this, "This will cancel the current operation!\nDo you wish to continue?", "BPME Setup", 0, 2);
                if (n != 0) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            this.setOperationCanceled(true);
            this.workerTh_.setMustStop(true);
            this.workerTh_.wakeup();
            this.closeUDP();
            try {
                this.workerTh_.join(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dispose();
            System.exit(0);
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void computeCRCValues() {
        this.setWaitCursor();
        this.workerTh_.addCmd(new GUIWorkerCmd(){

            public void execute() {
                BPMESetup.this.computeCRCs();
            }

            public void onFinished() {
                BPMESetup.this.restoreCursor();
            }
        });
    }

    private void computeCRCs() {
        Status.getInst().log("Computing CRC values...");
        String string = SetupProperties.getInst().getProperty("firmware");
        File file = new File(string);
        if (string.length() > 0) {
            this.lblFileNameFirmware_.setText(file.getName());
            this.lblCRCFirmware_.setText(BPMESetup.formatCRC16(this.computeCRC(file)));
        } else {
            this.lblFileNameFirmware_.setText(TXT_UNKNOWN_FILE_NAME);
            this.lblCRCFirmware_.setText(BPMESetup.formatCRC16(0));
        }
        string = SetupProperties.getInst().getProperty("webIn");
        file = new File(string);
        if (string.length() > 0) {
            this.lblFileNameWeb_.setText(file.getName());
            this.lblCRCWeb_.setText(BPMESetup.formatCRC16(this.computeCRC(file)));
        } else {
            this.lblFileNameWeb_.setText(TXT_UNKNOWN_FILE_NAME);
            this.lblCRCWeb_.setText(BPMESetup.formatCRC16(0));
        }
        Status.getInst().append("OK.\n");
    }

    private JPanel createFilesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Font font = new Font(null, 1, 14);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel("Firmware:");
        jLabel.setForeground(COLOR_FG);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.lblFileNameFirmware_ = new JLabel(TXT_UNKNOWN_FILE_NAME);
        this.lblFileNameFirmware_.setForeground(COLOR_FG);
        this.lblFileNameFirmware_.setFont(font);
        jPanel.add((Component)this.lblFileNameFirmware_, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jLabel = new JLabel("CRC:");
        jLabel.setForeground(COLOR_FG);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.lblCRCFirmware_ = new JLabel(BPMESetup.formatCRC16(0));
        this.lblCRCFirmware_.setForeground(COLOR_FG);
        this.lblCRCFirmware_.setFont(font);
        jPanel.add((Component)this.lblCRCFirmware_, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jLabel = new JLabel("Web:");
        jLabel.setForeground(COLOR_FG);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.lblFileNameWeb_ = new JLabel(TXT_UNKNOWN_FILE_NAME);
        this.lblFileNameWeb_.setForeground(COLOR_FG);
        this.lblFileNameWeb_.setFont(font);
        jPanel.add((Component)this.lblFileNameWeb_, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jLabel = new JLabel("CRC:");
        jLabel.setForeground(COLOR_FG);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        this.lblCRCWeb_ = new JLabel(BPMESetup.formatCRC16(0));
        this.lblCRCWeb_.setForeground(COLOR_FG);
        this.lblCRCWeb_.setFont(font);
        jPanel.add((Component)this.lblCRCWeb_, gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder("Files"));
        return jPanel;
    }

    private JPanel createNetworkPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.createFindBPMEPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel("BPMEs found on Network:");
        jLabel.setForeground(COLOR_FG);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.availIPsList_ = new DefaultListModel();
        this.lbAvailIPs_ = new JList(this.availIPsList_);
        this.lbAvailIPs_.setVisibleRowCount(7);
        this.lbAvailIPs_.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.lbAvailIPs_, 20, 31);
        jScrollPane.setPreferredSize(new Dimension(250, 100));
        this.availIPsList_.addElement("This box will fill with the ip");
        this.availIPsList_.addElement("addresses and names of units");
        this.availIPsList_.addElement("on your network");
        this.lbAvailIPs_.setEnabled(false);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.createCtrlPanel(), gridBagConstraints);
        jPanel.setBorder(BorderFactory.createTitledBorder(""));
        return jPanel;
    }

    private JPanel createFindBPMEPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel("Subnet Mask:");
        jLabel.setForeground(COLOR_FG);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.ipSubnetMask_ = new IPAddrEditPanel();
        this.ipSubnetMask_.setText("255.255.252.0");
        jPanel.add((Component)this.ipSubnetMask_, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        this.btnFindBPME_ = new JButton("Find BPMEs");
        this.btnFindBPME_.addActionListener(this);
        this.btnFindBPME_.setActionCommand("btnFindBPME_Click");
        jPanel.add((Component)this.btnFindBPME_, gridBagConstraints);
        return jPanel;
    }

    private JPanel createCtrlPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.anchor = 13;
        this.btnSetupDefault_ = new JButton("Set Defaults");
        this.btnSetupDefault_.addActionListener(this);
        this.btnSetupDefault_.setActionCommand("btnSetupDefault_Click");
        jPanel.add((Component)this.btnSetupDefault_, gridBagConstraints);
        this.btnLaunchWebPg_ = new JButton("Launch Unit Webpage");
        this.btnLaunchWebPg_.addActionListener(this);
        this.btnLaunchWebPg_.setActionCommand("btnLaunchWebPg_Click");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.btnLaunchWebPg_, gridBagConstraints);
        return jPanel;
    }

    private synchronized void setWaitCursor() {
        if (this.oldCursor_ == null) {
            this.oldCursor_ = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private synchronized void restoreCursor() {
        if (this.oldCursor_ != null) {
            this.setCursor(this.oldCursor_);
        }
        this.oldCursor_ = null;
    }

    private boolean uploadWebandFirmware(InetAddress inetAddress) {
        try {
            SetupProperties.getInst().load();
        }
        catch (Exception exception) {
            Status.getInst().log("Unable to load properties file!\n");
            return false;
        }
        if (SetupProperties.getInst().getProperty("isFirmwareEnabled").toLowerCase().equals("true")) {
            String string = SetupProperties.getInst().getProperty("firmware");
            if (!this.uploadToXPORT(string, "X5", inetAddress)) {
                if (SetupProperties.getInst().getProperty("isIntFirmwareEn").toLowerCase().equals("true")) {
                    Status.getInst().log("Trying different Version\n");
                    String string2 = SetupProperties.getInst().getProperty("intFirmware");
                    if (!this.uploadToXPORT(string2, "X2", inetAddress)) {
                        return false;
                    }
                    Status.getInst().log("Intermediate Firmware loaded\n");
                    Status.getInst().log("Xport is rebooting (~90 secs)...");
                    this.goToSleep(90000);
                    Status.getInst().append("OK.\n");
                    if (!this.uploadToXPORT(string, "X5", inetAddress)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            Status.getInst().log("Xport is rebooting (~30 sec)...");
            this.goToSleep(30000);
            Status.getInst().append("OK.\n");
        }
        if (SetupProperties.getInst().getProperty("isWebContentEnabled").toLowerCase().equals("true") && !this.uploadWebContent(inetAddress)) {
            return false;
        }
        Status.getInst().log("Web and/or firmware loaded\n");
        return true;
    }

    private void launchWebPage() {
        int n = this.lbAvailIPs_.getSelectedIndex();
        if (n == -1) {
            return;
        }
        int[] nArray = new int[]{n};
        boolean bl = true;
        String string = "";
        for (int i = 0; i < nArray.length && !this.isOperationCanceled(); ++i) {
            string = this.getAvailIP(nArray[i]);
            string = string.substring(0, string.indexOf(32));
            String[] stringArray = new String[]{"iexplore", "http://" + string};
            Runtime runtime = Runtime.getRuntime();
            try {
                Process process = runtime.exec(stringArray);
                Status.getInst().log("Opening Internet Explorer...\n");
            }
            catch (Exception exception) {
                try {
                    stringArray[0] = "netscp";
                    Process process = runtime.exec(stringArray);
                    Status.getInst().log("Opening Netscape Navigator...\n");
                }
                catch (Exception exception2) {
                    try {
                        stringArray[0] = "firefox";
                        Process process = runtime.exec(stringArray);
                        Status.getInst().log("Opening Mozilla Firefox...\n");
                    }
                    catch (Exception exception3) {
                        bl = false;
                        break;
                    }
                }
            }
            this.goToSleep(1000);
        }
        if (!bl) {
            String string2 = "";
            string2 = string.length() > 0 ? "Enter the following URL in the address bar of your web browser:\nhttp://" + string : "Enter the IP address of the desired BPME in the address bar of your web browser.";
            try {
                JOptionPane.showMessageDialog(this, "Unable to find a web browser in your system path.\n" + string2, "BPME Setup", 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Status.getInst().log("Error opening browser\n");
        }
    }

    private void handle_launchWebPage() {
        this.workerTh_.addCmd(new WorkerCmd(){

            public void execute() {
                BPMESetup.this.launchWebPage();
            }

            public void finished() {
            }
        });
    }

    private void setDefaultSettings() {
        int n = this.lbAvailIPs_.getSelectedIndex();
        if (n == -1) {
            return;
        }
        int[] nArray = new int[]{n};
        for (int i = 0; i < nArray.length && !this.isOperationCanceled(); ++i) {
            String string = this.getAvailIP(nArray[i]);
            string = string.substring(0, string.indexOf(32));
            Status.getInst().log("Setting defaults for BPME at " + string + "...\n");
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                Status.getInst().log("IP address couldn't be found\n");
                break;
            }
            if (!this.unlockXport(inetAddress) || !this.uploadWebandFirmware(inetAddress)) break;
        }
        if (!this.isOperationCanceled()) {
            this.findBPME();
        }
    }

    private void handle_setDefaultSettings() {
        this.setWaitCursor();
        this.btnSetupDefault_.setEnabled(false);
        this.btnFindBPME_.setEnabled(false);
        this.btnLaunchWebPg_.setEnabled(false);
        this.workerTh_.addCmd(new GUIWorkerCmd(){

            public void execute() {
                BPMESetup.this.setExecuting(true);
                BPMESetup.this.setDefaultSettings();
            }

            public void onFinished() {
                BPMESetup.this.setExecuting(false);
                BPMESetup.this.btnSetupDefault_.setEnabled(true);
                BPMESetup.this.btnFindBPME_.setEnabled(true);
                BPMESetup.this.btnLaunchWebPg_.setEnabled(true);
                BPMESetup.this.restoreCursor();
            }
        });
    }

    private void findBPME() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            Dbg.getInst().log("main Local IP Address : " + inetAddress.getHostAddress(), Dbg.LVL_SYS);
            byte[] byArray = inetAddress.getAddress();
            int[] nArray = new int[4];
            byte[] byArray2 = new byte[4];
            this.ipSubnetMask_.getFields(nArray);
            for (int i = 0; i < 4; ++i) {
                byArray2[i] = (byte)((~nArray[i] | byArray[i] & nArray[i]) & 0xFF);
            }
            InetAddress inetAddress2 = InetAddress.getByAddress(byArray2);
            Dbg.getInst().log("Broadcast IP Address : " + inetAddress2.getHostAddress(), Dbg.LVL_SYS);
            this.port_ = 30718;
            this.cmd_ = (byte)-27;
            if (inetAddress2 != null && this.gtp_ == null) {
                this.gtp_ = new udpip(inetAddress2, this.port_);
                if (this.gtp_.s == null) {
                    Status.getInst().log("Connecting to " + inetAddress2.getHostAddress() + ":" + this.port_ + " failed!\n");
                    return;
                }
            }
            this.lbAvailIPs_.setEnabled(true);
            this.clearAvailIPs();
            this.cmdStr_ = new byte[18];
            this.cmdStr_[3] = this.cmd_;
            this.gtp_.send(this.cmdStr_, this.cmdStr_.length);
            while (!this.isOperationCanceled()) {
                this.resp_ = this.gtp_.receive(130, 3000);
                if (this.resp_ != null) {
                    String string = new String(this.resp_).substring(106);
                    string = string.indexOf(0) == -1 ? "" : string.substring(0, string.indexOf(0));
                    this.addAvailIP(this.gtp_.rcvaddr.getHostAddress() + " " + string);
                    Thread.yield();
                    continue;
                }
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Status.getInst().log("IP address couldn't be found\n");
        }
        catch (Exception exception) {
            Status.getInst().log("Error while finding BPMEs!\n");
        }
        this.closeUDP();
    }

    private void handle_findBPME() {
        this.setWaitCursor();
        this.btnSetupDefault_.setEnabled(false);
        this.btnFindBPME_.setEnabled(false);
        this.btnLaunchWebPg_.setEnabled(false);
        this.workerTh_.addCmd(new GUIWorkerCmd(){

            public void execute() {
                BPMESetup.this.setExecuting(true);
                BPMESetup.this.findBPME();
            }

            public void onFinished() {
                BPMESetup.this.setExecuting(false);
                BPMESetup.this.btnSetupDefault_.setEnabled(true);
                BPMESetup.this.btnFindBPME_.setEnabled(true);
                BPMESetup.this.btnLaunchWebPg_.setEnabled(true);
                BPMESetup.this.restoreCursor();
            }
        });
    }

    private boolean uploadToXPORT(String string, String string2, InetAddress inetAddress) {
        String[] stringArray = new String[]{"tftp", "-i", inetAddress.getHostAddress(), "PUT", string, string2};
        boolean bl = true;
        Runtime runtime = Runtime.getRuntime();
        try {
            Status.getInst().log("Uploading " + string + "...");
            Process process = runtime.exec(stringArray);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getErrorStream());
            int n = bufferedInputStream.read();
            if (n != -1) {
                byte[] byArray = new byte[40];
                byArray[0] = (byte)n;
                int n2 = bufferedInputStream.read(byArray, 1, 39);
                Dbg.getInst().log("Error uploading" + string + ": " + new String(byArray), Dbg.LVL_SYS);
                throw new Exception();
            }
            Status.getInst().append("OK.\n");
        }
        catch (Exception exception) {
            Status.getInst().log("FAILED!\n");
            bl = false;
        }
        return bl;
    }

    private boolean uploadWebContent(InetAddress inetAddress) {
        boolean bl = true;
        try {
            int n;
            String string = SetupProperties.getInst().getProperty("webIn");
            String string2 = SetupProperties.getInst().getProperty("webOutDir");
            Status.getInst().log("Exctracting " + string + "...");
            try {
                WebContent webContent = new WebContent(string);
                webContent.extract(string2);
                SetupProperties.getInst().setProperty("numWebFiles", Integer.toString(webContent.getNumFiles()));
                for (n = 0; n < webContent.getNumFiles(); ++n) {
                    WebContentFile webContentFile = webContent.getFile(n);
                    if (webContentFile == null) continue;
                    SetupProperties.getInst().setWebContentFileName(n, webContentFile.getDestination(), webContentFile.getAbsolutePath());
                    Thread.yield();
                }
            }
            catch (IOException iOException) {
                Status.getInst().append("FAILED!\n");
                throw iOException;
            }
            Status.getInst().append("OK.\n");
            int n2 = Integer.parseInt(SetupProperties.getInst().getProperty("numWebFiles"));
            n = 0;
            for (int i = 0; i < n2; ++i) {
                String string3 = SetupProperties.getInst().getWebContentFileDest(i);
                String string4 = SetupProperties.getInst().getWebContentFileName(i);
                if (!this.uploadToXPORT(string4, string3, inetAddress)) {
                    if (n != 0) {
                        bl = false;
                        break;
                    }
                    Status.getInst().log("Trying Again...\n");
                    n = 1;
                    if (!this.unlockXport(inetAddress)) {
                        bl = false;
                        break;
                    }
                    --i;
                }
                this.goToSleep(500);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private int computeCRC(File file) {
        if (file == null) {
            Dbg.getInst().log("inFile is null!", 2);
            return 0;
        }
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            long l = file.length();
            if (l == 0L) {
                Dbg.getInst().log("inFile is EMPTY!", 2);
                throw new Exception();
            }
            int n2 = (int)Math.min(l / 100L, 32768L);
            n2 = Math.max(n2, 1);
            int n3 = (int)(l / (long)n2);
            if (l % (long)n2 != 0L) {
                ++n3;
            }
            Dbg.getInst().log("bytesToRead=" + l + "; " + "blockSize=" + n2 + "; numBlocks=" + n3, 2);
            byte[] byArray = new byte[n2];
            CRC.startRollingCRC();
            int n4 = 0;
            while (!this.isOperationCanceled()) {
                Arrays.fill(byArray, (byte)0);
                n4 = fileInputStream.read(byArray, 0, n2);
                for (int i = 0; i < n4 && !this.isOperationCanceled(); ++i) {
                    CRC.rollingCRC(byArray[i]);
                }
                if (n4 != n2) break;
                Thread.yield();
            }
            n = CRC.finishRollingCRC();
            Dbg.getInst().log("crc16=" + n, 2);
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            byArray = null;
        }
        catch (Exception exception) {
            exception.printStackTrace(Dbg.getInst().getPrintStream());
        }
        return n;
    }

    private synchronized boolean unlockXport(InetAddress inetAddress) {
        this.port_ = 10004;
        this.encTcp = new EncryptedTCPIPCommInt(inetAddress, this.port_, 1024);
        try {
            this.encTcp.open();
        }
        catch (Exception exception) {
            Status.getInst().log("TCP Connection to " + inetAddress.getHostAddress() + ":" + this.port_ + " failed!\n");
            Status.getInst().log("   - Can ignore if a virgin part\n");
            Dbg.getInst().log("TCP Connection to " + inetAddress.getHostAddress() + ":" + this.port_ + " failed!", Dbg.LVL_SYS);
            Dbg.getInst().log("socket is Null", Dbg.LVL_SYS);
            this.encTcp.close();
            this.encTcp = null;
            return true;
        }
        try {
            byte[] byArray = "unlock all ports".getBytes();
            int n = this.encTcp.send(byArray, byArray.length, 1000);
            if (n != byArray.length) {
                throw new Exception();
            }
            byte[] byArray2 = new byte[8];
            n = this.encTcp.receive(byArray2, byArray2.length, 5000);
            if (n != byArray2.length) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            Status.getInst().log("TCP Connection to " + inetAddress.getHostAddress() + ":" + this.port_ + " failed!\n");
            Dbg.getInst().log("TCP Connection to " + inetAddress.getHostAddress() + ":" + this.port_ + " failed!", Dbg.LVL_SYS);
            Dbg.getInst().log("No Response from command", Dbg.LVL_SYS);
            this.encTcp.close();
            this.encTcp = null;
            return false;
        }
        this.encTcp.close();
        return true;
    }

    private boolean setSetupRecords(InetAddress inetAddress) {
        boolean bl = true;
        try {
            this.port_ = 30718;
            if (inetAddress != null) {
                if (this.gtp_ == null) {
                    this.gtp_ = new udpip(inetAddress, this.port_);
                    if (this.gtp_.s == null) {
                        Status.getInst().log("Connecting to " + inetAddress.getHostAddress() + ":" + this.port_ + " failed!\n");
                        throw new Exception();
                    }
                }
            } else {
                throw new Exception();
            }
            for (int i = 0; i <= 7; ++i) {
                Thread.yield();
                this.cmd_ = (byte)(192 + i);
                this.cmdStr_ = i == 0 ? new byte[124] : new byte[130];
                this.cmdStr_[3] = this.cmd_;
                this.cmdStr_[1] = 1;
                if (i != 0 && i != 1) {
                    if (i == 2) continue;
                    if (i == 3) {
                        this.cmdStr_[117] = 25;
                    } else {
                        int n;
                        byte[] byArray;
                        String string;
                        if (i == 4) continue;
                        if (i == 5) {
                            string = "bpmeDefault";
                            byArray = string.getBytes();
                            for (n = 0; n < byArray.length; ++n) {
                                this.cmdStr_[106 + n] = byArray[n];
                            }
                        } else if (i == 6) {
                            string = "bpme.com";
                            byArray = string.getBytes();
                            for (n = 0; n < byArray.length; ++n) {
                                this.cmdStr_[4 + n] = byArray[n];
                            }
                            this.cmdStr_[29] = 6;
                            string = "bird";
                            byArray = string.getBytes();
                            for (n = 0; n < byArray.length; ++n) {
                                this.cmdStr_[30 + n] = byArray[n];
                                this.cmdStr_[80 + n] = byArray[n];
                            }
                        } else if (i == 7) {
                            string = "public";
                            byArray = string.getBytes();
                            for (n = 0; n < byArray.length; ++n) {
                                byte by = byArray[n];
                                this.cmdStr_[50 + n] = by;
                                this.cmdStr_[36 + n] = by;
                            }
                        }
                    }
                }
                this.gtp_.send(this.cmdStr_, this.cmdStr_.length);
                this.resp_ = this.gtp_.receive(4, 3000);
                if (this.resp_ == null) {
                    Status.getInst().log("Couldn't set setup record " + i + "\n");
                    bl = false;
                    break;
                }
                Status.getInst().log("Setup record " + i + " set to defaults\n");
            }
        }
        catch (Exception exception) {
            this.closeUDP();
            return false;
        }
        this.closeUDP();
        if (bl) {
            Status.getInst().log("Setup records set successfully!\n");
            return true;
        }
        Status.getInst().log("All setup records not set!\n");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeUDP() {
        try {
            if (this.gtp_ != null) {
                this.gtp_.disconnect();
                this.gtp_ = null;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.gtp_ = null;
        }
    }

    private synchronized boolean isUDPOpen() {
        return this.gtp_ != null;
    }

    private synchronized void goToSleep(int n) {
        try {
            this.wait(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void setOperationCanceled(boolean bl) {
        this.isOperationCanceled_ = bl;
    }

    private boolean isOperationCanceled() {
        return this.isOperationCanceled_;
    }

    private void setExecuting(boolean bl) {
        this.isExecuting_ = bl;
    }

    private synchronized void addAvailIP(String string) {
        try {
            this.availIPsList_.addElement(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized String getAvailIP(int n) {
        String string = "";
        try {
            string = (String)this.availIPsList_.elementAt(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private synchronized void clearAvailIPs() {
        try {
            this.availIPsList_.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String formatCRC16(int n) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() > 4) {
            string = string.substring(4, string.length());
        }
        int n2 = 4 - string.length();
        for (int i = 0; i < n2; ++i) {
            string = "0" + string;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    BPMESetup.createAndShowGUI();
                }
            });
        }
        catch (Exception exception) {
            System.out.println("FATAL ERROR - Unable to create GUI!");
            exception.printStackTrace(System.out);
            System.exit(0);
        }
    }

    private static void createAndShowGUI() {
        Dbg.getInst().init(Dbg.LVL_SYS);
        BPMESetup bPMESetup = new BPMESetup("BPME Setup v1.3");
        bPMESetup.setSize(440, 480);
        bPMESetup.setResizable(false);
        bPMESetup.show();
        SetupProperties.getInst().loadAndRestore();
        bPMESetup.computeCRCValues();
    }

    class StatusKeyAdapter
    extends KeyAdapter {
        StatusKeyAdapter() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = 576;
            if (keyEvent.getKeyCode() == 120 && (keyEvent.getModifiersEx() & n) == n) {
                SetupProperties.getInst().loadAndRestore();
                FilesDialog filesDialog = new FilesDialog(null, "Files");
                filesDialog.show();
                try {
                    SetupProperties.getInst().store();
                    BPMESetup.this.computeCRCValues();
                }
                catch (Exception exception) {
                    Status.getInst().log("Couldn't write to props file.\n");
                }
            } else {
                keyEvent.consume();
            }
        }
    }
}

